/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import com.inet.report.Area;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.Section;

/**
 * This sample replace a picture in the Page Header section with another picture at runtime
 */
public class ChangePictureAtRuntime extends RDCSample {

    // Change the URL of the rpt file before running this example if you use another report file.
    private static final String REPORT = "samples/sample.rpt";

    /**
     * Replace a picture in an existing report.
     * @param exportFmt the output format (e.g. Engine.EXPORT_PDF)
     * @return the new engine for the report
     */
    @Override
    public Engine createAndFillEngine( String exportFmt ) {
        Engine eng = null;
        try {
            eng = new Engine( exportFmt );
            eng.setReportFile( REPORT );
            Area pageHeaderArea = eng.getArea( "PH" );
            Section pageHeaderSection = pageHeaderArea.getSection( 0 );

            for( Element element : pageHeaderSection.getElements() ) {
                int x, y;
                if( element instanceof com.inet.report.Picture ) {
                    // position of the old picture
                    x = element.getX();
                    y = element.getY();
                    // remove old picture                    
                    pageHeaderSection.remove( element );
                    // add new picture
                    pageHeaderSection.addPicture( x + 1000, y + 1000, 2835, 375, "samples/rdc/cc_logo.png" );
                }
            }
        } catch( ReportException ex ) {
            ex.printStackTrace();
            System.exit( 0 );
        } catch( Throwable e ) {
            e.printStackTrace();
            System.exit( 0 );
        }
        return eng;
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        new ChangePictureAtRuntime().initUI();
    }
}
